function r = rank(Y,L)

[n1,n2,n3] = size(Y);
temp       = ttm(Y,L,3);
temp       = double(temp);
t          = zeros(n3,1);
tol        = max(n1,n2)*eps(max(temp(:)));

for i = 1 : n3
    [~,s,~] = svd(temp(:,:,i));
    diags   = diag(s);
    t(i)    = length(find(diags>tol));
end

r = sum(t)/n3;
end